// Application : XbaseInterface
// XbDate.prg , Created : 11.10.2019   05:48

begin namespace XbaseInterface

#region Class declaration

class XbDate
	protect _oDatum		as Nullable<DateTime>

#endregion
#region Constructors

constructor()

	_oDatum				:= null

	return

constructor( oDatum as Nullable<DateTime> )

	_oDatum				:= oDatum

	return

constructor( nYear as int, nMonth as int, nDay as int )

    _oDatum				:= null
    try
    _oDatum				:= DateTime{ nYear, nMonth, nDay }
    end try

    return

constructor( cDateString as string )
	local nYear			as int
	local nMonth		as int
	local nDay			as int

	_oDatum				:= null
	try
	nYear				:= 0
	nMonth				:= 0
	nDay				:= 0
	if Int32.TryParse( cDateString:Substring( 0, 4 ), ref nYear ) .and. ;
	   Int32.TryParse( cDateString:Substring( 4, 2 ), ref nMonth ) .and. ;
	   Int32.TryParse( cDateString:Substring( 6, 2 ), ref nDay )
		_oDatum				:= DateTime{ nYear, nMonth, nDay }
	endif
	end try

	return

#endregion
#region Properties

property DateTime as Nullable<DateTime> get _oDatum
property DateString as string
	get
		if _oDatum == null
			return ""
		endif
		return ( ( DateTime ) _oDatum ):ToString("yyyyMMdd", System.Globalization.CultureInfo.InvariantCulture )
	end get
end property
property Year as int
	get
		if _oDatum == null
			return 0
		endif
		return ( ( DateTime ) _oDatum ):Year
	end get
end property
property Month as int
	get
		if _oDatum == null
			return 0
		endif
		return ( ( DateTime ) _oDatum ):Month
	end get
end property
property Day as int
	get
		if _oDatum == null
			return 0
		endif
		return ( ( DateTime ) _oDatum ):Day
	end get
end property
property Empty as logic get _oDatum == null

#endregion
#region Operators

public static operator >( oDate1 as XbDate, oDate2 as XbDate ) as logic

	return oDate1?:DateTime > oDate2?:DateTime

public static operator <( oDate1 as XbDate, oDate2 as XbDate ) as logic

	return oDate1?:DateTime > oDate2?:DateTime

public static operator <=( oDate1 as XbDate, oDate2 as XbDate ) as logic

	return oDate1?:DateTime <= oDate2?:DateTime

public static operator >=( oDate1 as XbDate, oDate2 as XbDate ) as logic

	return oDate1?:DateTime >= oDate2?:DateTime

public static operator !=( oDate1 as XbDate, oDate2 as XbDate ) as logic

	return oDate1?:DateTime != oDate2?:DateTime

public static operator ==( oDate1 as XbDate, oDate2 as XbDate ) as logic

	return oDate1?:DateTime == oDate2?:DateTime

public static operator -( oDate as XbDate, nRange as int ) as XbDate
	local dResult		as XbDate

	do case
	case oDate == null
		dResult			:= null
	case oDate:DateTime == null
		dResult			:= XbDate{ ( DateTime? ) null }
	otherwise
		dResult			:= XbDate{ ( ( DateTime ) oDate:DateTime ):AddDays( - nRange ) }
	endcase

	return dResult

public static operator +( oDate as XbDate, nRange as int ) as XbDate
	local dResult		as XbDate

	do case
	case oDate == null
		dResult			:= null
	case oDate:DateTime == null
		dResult			:= XbDate{ ( DateTime? ) null }
	otherwise
		dResult			:= XbDate{ ( ( DateTime ) oDate:DateTime ):AddDays( + nRange ) }
	endcase

	return dResult

method GetHashCode() as int

	return _oDatum:GetHashCode()

method Equals( oDate as object ) as logic
	local lReturn			as logic

	if oDate is XbDate
		lReturn				:= ( ( ( XbDate ) oDate ):DateTime == self:DateTime )
	else
		lReturn				:= false
	endif

	return lReturn


#endregion

end class

end namespace

