// Application : XbaseInterface
// CoreDBFServer.prg , Created : 11.10.2019   05:51

begin namespace XbaseInterface

#region Class declaration

class CoreDBFServer implements IDisposable
	protect _oDBServer			as AppDBServer

#endregion
#region Constructor


constructor( cFileName as string, lShareMode as logic, lReadOnlyMode as logic, cRDDName as string )

	_oDBServer		:= AppDBServer{ cFileName, lShareMode, lReadOnlyMode, cRDDName }

	return

destructor()

	self:CleanUp()

	return

#endregion
#region public methods

virtual method CheckField( cFieldName as string ) as logic
	local lReturn			as logic

	if _oDBServer:FieldPos( cFieldName ) == 0
		lReturn					:= false
		throw ArgumentException{ i"Field {cFieldName} does not exists!", cFieldName }
	else
		lReturn					:= true
	endif

	return lReturn

virtual method CleanUp() as void

	if _oDBServer != null
		if _oDBServer:Used
			_oDBServer:CloseEx()
		endif
		_oDBServer			:= null
	endif

	return

virtual method Close() as logic

	return _oDBServer:Close()

virtual method Commit() as void

	_oDBServer:Commit()

	return

virtual method FieldGetDecimal( cFieldName as string ) as decimal
	local nValue		as decimal

	if self:CheckField( cFieldName )
		nValue			:= _oDBServer:FieldGetDecimal( cFieldName )
	else
		nValue			:= 0m
	endif

	return nValue

virtual method FieldGetInt( cFieldName as string ) as int
	local nValue		as int

	if self:CheckField( cFieldName )
		nValue			:= _oDBServer:FieldGetInt( cFieldName )
	else
		nValue			:= 0
	endif

	return nValue

virtual method FieldGetString( cFieldName as string ) as string
	local cValue		as string

	if self:CheckField( cFieldName )
		cValue			:= _oDBServer:FieldGetString( cFieldName )
	else
		cValue			:= ""
	endif

	return cValue

virtual method FieldGetLogic( cFieldName as string ) as logic
	local lValue		as logic

	if self:CheckField( cFieldName )
		lValue			:= _oDBServer:FieldGetLogic( cFieldName )
	else
		lValue			:= false
	endif

	return lValue

virtual method FGInt( cFieldName as string ) as int
	local nValue		as int

	if self:CheckField( cFieldName )
		nValue			:= _oDBServer:FieldGetInt( cFieldName )
	else
		nValue			:= 0
	endif

	return nValue

virtual method FGTrim( cFieldName as string ) as string
	local cValue		as string

	if self:CheckField( cFieldName )
		cValue			:= _oDBServer:FGTrim( cFieldName )
	else
		cValue			:= ""
	endif

	return cValue

virtual method FieldGetDate( cFieldName as string ) as XbDate
	local dValue		as XbDate

	if self:CheckField( cFieldName )
		dValue			:= _oDBServer:FieldGetDate( cFieldName )
	else
		dValue			:= XbDate{}
	endif

	return dValue

virtual method FieldGetDateTime( cFieldName as string ) as DateTime
	local dValue		as DateTime

	if self:CheckField( cFieldName )
		dValue			:= _oDBServer:FieldGetDateTime( cFieldName )
	else
		dValue			:= DateTime.MinValue
	endif

	return dValue

virtual method FieldGetNullableDateTime( cFieldName as string ) as Nullable<DateTime>
	local dValue		as Nullable<DateTime>

	if self:CheckField( cFieldName )
		dValue			:= _oDBServer:FieldGetNullableDateTime( cFieldName )
	else
		dValue			:= null
	endif

	return dValue

virtual method FieldPutString( cFieldName as string, cValue as string ) as void

	if self:CheckField( cFieldName )
		_oDBServer:FieldPut( cFieldName, cValue )
	endif

	return

virtual method FieldGetDateString( cFieldName as string ) as string
	local cValue		as string

	if self:CheckField( cFieldName )
		cValue			:= _oDBServer:FieldGetDateString( cFieldName )
	else
		cValue			:= ""
	endif

	return cValue

virtual method FieldPutDecimal( cFieldName as string, nValue as decimal ) as void

	if self:CheckField( cFieldName )
		_oDBServer:FieldPut( cFieldName, nValue )
	endif

	return

virtual method FieldPutInt( cFieldName as string, nValue as int ) as void

	if self:CheckField( cFieldName )
		_oDBServer:FieldPut( cFieldName, nValue )
	endif

	return

virtual method FieldPutLogic( cFieldName as string, lValue as logic ) as void

	if self:CheckField( cFieldName )
		_oDBServer:FieldPut( cFieldName, lValue )
	endif

	return

virtual method FieldPutDateTime( cFieldName as string, dValue as DateTime ) as void

	if self:CheckField( cFieldName )
		_oDBServer:FieldPut( cFieldName, dValue )
	endif

	return

virtual method GoBottom() as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:GoBottom()

	return lReturn

virtual method Goto( nRecno as int ) as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:Goto( nRecno )

	return lReturn

virtual method GoTop() as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:GoTop()

	return lReturn

virtual method LockCurrentRecord() as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:LockCurrentRecord()

	return lReturn

virtual method Seek( cSearchExpr as string ) as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:SeekEx( cSearchExpr )

	return lReturn

virtual method Seek( cSearchExpr as string, lSoftSeek as logic ) as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:SeekEx( cSearchExpr, lSoftSeek )

	return lReturn

virtual method Seek( cSearchExpr as string, lSoftSeek as logic, lLast as logic ) as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:SeekEx( cSearchExpr, lSoftSeek, lLast )

	return lReturn

virtual method SetOrder( cOrderName as string ) as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:SetOrder( cOrderName )

	return lReturn

virtual method Skip() as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:Skip( 1 )

	return lReturn


virtual method Skip( nRecords as int ) as logic
	local lReturn			as logic

	lReturn			:= _oDBServer:Skip( nRecords )

	return lReturn

virtual method Unlock() as void

	_oDBServer:Unlock()

	return


#endregion
#region IDisposable interface

virtual method Dispose() as void

	self:CleanUp()

	return

#endregion
#region Properties

virtual property EoF as logic
	get
		local lReturn			as logic

		lReturn			:= _oDBServer:EoF

		return lReturn
	end get
end property
virtual property Used as logic
	get
		local lReturn			as logic

		if _oDBServer == null
			lReturn			:= false
		else
			lReturn			:= _oDBServer:Used
		endif

		return lReturn
	end get
end property
virtual property Recno as int
	get
		local nRecno			as int

		if _oDBServer == null
			nRecno			:= 0
		else
			nRecno			:= _oDBServer:Recno
		endif

		return nRecno
	end get
end property

#endregion

end class

end namespace


