// Application : XSharp.Tools.SqlSample
// Form1.Code , Created : 24.09.2022   18:58
// User : Wolfgang

using System.Collections.Generic
using System.Windows.Forms
using System.Data
using XSharp.Tools
using XSharp.Tools.SqlBase
using XSharp.Tools.AdsSQL
using XSharp.Tools.MySQL
using XSharp.Tools.PostgreSQL
using XSharp.Tools.SQLite
using MySQLConnector
//using MySQL.Data
//using MySql.Data.MySqlClient

class BasicForm inherit _BasicForm
	protect _oIniFile		as IniFile


constructor()

	super()
	self:Initialize()

	return

method Initialize() as logic
	local oDBTypes			as List<string>

	_oIniFile			:= IniFile{ System.IO.Path.Combine( AppDomain.CurrentDomain:BaseDirectory, "XSharp.Tools.SQLSample.ini" ) }

	oDBTypes			:= List<string>{}
	oDBTypes:Add( "Advantage Database Server" )
	oDBTypes:Add( "PostgreSQL" )
	oDBTypes:Add( "MySQL" )
	oDBTypes:Add( "SQLite" )
	oDatabaseType:DataSource	:= oDBTypes
	oDatabaseType:Text			:= _oIniFile:GetString( "Settings", "DatabaseType", "SQLite" )
	self:RestoreValues()

	oExecuteButton:Click		+= ExecuteStatement
	oCloseButton:Click			+= ExecuteClose
	oDatabaseType:SelectedValueChanged	+= DatabaseChanged

    return true

method RestoreValues() as void
	local cDatabaseType		as string

	cDatabaseType				:= oDatabaseType:Text
	if ! String.IsNullOrEmpty( cDatabaseType )
		oServerName:Text			:= _oIniFile:GetString( cDatabaseType, "ServerName", "" )
		oDatabase:Text				:= _oIniFile:GetString( cDatabaseType, "Database", "" )
		oUserName:Text				:= _oIniFile:GetString( cDatabaseType, "UserName", "" )
		oPassword:Text				:= _oIniFile:GetString( cDatabaseType, "Password", "" )
		oStmt:Text					:= _oIniFile:GetString( cDatabaseType, "Stmt", "" )
	endif


method DatabaseChanged(sender as object , e as EventArgs) as void

	self:RestoreValues()

	return

method ExecuteStatement(sender as object , e as EventArgs) as void
	local cDatabaseType		as string

	cDatabaseType				:= oDatabaseType:Text
	if ! String.IsNullOrEmpty( cDatabaseType )
		_oIniFile:WriteString( cDatabaseType, "ServerName", oServerName:Text )
		_oIniFile:WriteString( cDatabaseType, "Database", oDatabase:Text )
		_oIniFile:WriteString( cDatabaseType, "UserName", oUserName:Text )
		_oIniFile:WriteString( cDatabaseType, "Password", oPassword:Text )
		_oIniFile:WriteString( cDatabaseType, "Stmt", oStmt:Text )
	endif

	do switch cDatabaseType
	case "Advantage Database Server"
		self:ExecuteADS()
	case "PostgreSQL"
		self:ExecutePostgreSQL()
	case "MySQL"
		self:ExecuteMySQL()
	case "SQLite"
		self:ExecuteSQLite()
	otherwise
		self:ErrBox( "Unsupported database type " + cDatabaseType )
	end switch

	return

method ExecuteClose(sender as object , e as EventArgs) as void

	self:Close()


	return

method ExecuteADS() as void
	local cDatabase			as string
	local cStmt				as string
	local oConn				as AdsSqlConnection
	local oData				as DataTable

	if self:CheckParameters( false ) == false
		return
	endif
	oConn					:= null
	try
	cDatabase				:= oDatabase:Text:Trim()
	cStmt					:= oStmt:Text:Trim()
	oConn					:= AdsSqlConnection{ cDatabase, "", "", "" }
	if oConn:Connected == false
		oMessages:Text			:= oConn:LastError
	else
		if cStmt:ToLower():StartsWith( "select" )
			oData					:= oConn:GetDataTable( cStmt )
			oDataGrid:DataSource	:= oData
		else
			oConn:ExecuteStatement( cStmt )
		endif
	endif


    catch oEx as Exception

    self:ErrBox( oEx:Message )

	end try
	if oConn != null
		oConn:Dispose()
		oConn				:= null
	endif


	return

method ExecutePostgreSQL() as void
	local cServerName		as string
	local cDatabase			as string
	local cUsername			as string
	local cPassword			as string
	local cStmt				as string
	local oConn				as PGConnection
	local oData				as DataTable

	if self:CheckParameters( true ) == false
		return
	endif
	oConn					:= null

	try
	cServerName				:= oServerName:Text:Trim()
	cDatabase				:= oDatabase:Text:Trim()
	cUserName				:= oUserName:Text:Trim()
	cPassword				:= oPassword:Text:Trim()
	cStmt					:= oStmt:Text:Trim()
	oConn					:= PGConnection{ cServerName, cDatabase, cUserName, cPassword }
	if oConn:Connected == false
		oMessages:Text			:= oConn:LastError
	else
		if cStmt:ToLower():StartsWith( "select" )
			oData					:= oConn:GetDataTable( cStmt )
			oDataGrid:DataSource	:= oData
		else
			oConn:ExecuteStatement( cStmt )
		endif
	endif


    catch oEx as Exception

    self:ErrBox( oEx:Message )

	end try
	if oConn != null
		oConn:Dispose()
		oConn				:= null
	endif

	return

method ExecuteMySQL() as void
	local cServerName		as string
	local cDatabase			as string
	local cUsername			as string
	local cPassword			as string
	local cStmt				as string
	local oConn				as MyConnection
	local oData				as DataTable

	if self:CheckParameters( true ) == false
		return
	endif
	oConn					:= null

	altd()

	try
	cServerName				:= oServerName:Text:Trim()
	cDatabase				:= oDatabase:Text:Trim()
	cUserName				:= oUserName:Text:Trim()
	cPassword				:= oPassword:Text:Trim()
	cStmt					:= oStmt:Text:Trim()

	oConn					:= MyConnection{ cServerName, cDatabase, cUsername, cPassword }
	if oConn:Connected == false
		self:ErrBox( oConn:LastError )
	else
		if cStmt:ToLower():StartsWith( "select" )
			oData					:= oConn:GetDataTable( cStmt )
			oDataGrid:DataSource	:= oData
			if oData == null .and. ! String.IsNullOrEmpty( oConn:LastError )
				self:ErrBox( oConn:LastError )
			endif
		else
			oConn:ExecuteStatement( cStmt )
		endif
	endif

    catch oEx as Exception

    self:ErrBox( oEx:Message )

	end try
	if oConn != null
		oConn:Dispose()
		oConn				:= null
	endif

	return

method ExecuteSQLite() as void
	local cDatabase			as string
	local cStmt				as string
	local oConn				as SQLiteConn
	local oData				as DataTable

	if self:CheckParameters( false ) == false
		return
	endif
	oConn					:= null
	try
	cDatabase				:= oDatabase:Text:Trim()
	cStmt					:= oStmt:Text:Trim()
	oConn					:= SQLiteConn{ "", cDatabase, "", "" }
	if oConn:Connected == false
		oMessages:Text			:= oConn:LastError
	else
		if cStmt:ToLower():StartsWith( "select" )
			oData					:= oConn:GetDataTable( cStmt )
			oDataGrid:DataSource	:= oData
		else
			oConn:ExecuteStatement( cStmt )
		endif
	endif


    catch oEx as Exception

    self:ErrBox( oEx:Message )

	end try
	if oConn != null
		oConn:Dispose()
		oConn				:= null
	endif

	return

method CheckParameters( lCredentials as logic ) as logic

	if lCredentials .and. String.IsNullOrEmpty( oServerName:Text )
		self:ErrBox( "no server name" )
		return false
	endif
	if String.IsNullOrEmpty( oDatabase:Text )
		self:ErrBox( "no database" )
		return false
	endif
	if lCredentials .and. String.IsNullOrEmpty( oUserName:Text )
		self:ErrBox( "no user name" )
		return false
	endif
	if lCredentials .and. String.IsNullOrEmpty( oPassword:Text )
		self:ErrBox( "no password" )
		return false
	endif
	if String.IsNullOrEmpty( oStmt:Text )
		self:ErrBox( "no SQL statement" )
		return false
	endif

	return true

method ErrBox( cMessage as string ) as void

	MessageBox.Show( self, cMessage, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error )

	return

end class
