﻿// RelayCommand.prg
// Created by    : Wolfgang
// Creation Date : 3/13/2018 6:06:22 AM
// Created for   : 
// WorkStation   : FAWKES

using System
using System.Windows.Input
using System.Diagnostics


public class RelayCommand implements ICommand
#region Fields
	protect _oExecute 			as Action<object>
	protect _oCanExecute		as Predicate<object>
#endregion // Fields

#region Constructors

public constructor( oExecute as Action<object> )
	
	_oExecute				:= oExecute
	_oCanExecute			:= null
	
	return
	
public constructor( oExecute as Action<object>, oCanExecute as Predicate<object> )
	
	_oExecute				:= oExecute
	_oCanExecute			:= oCanExecute
	
	return
	
#endregion // Constructors

#region ICommand Members

[DebuggerStepThrough];
public method CanExecute( oParameter as object ) as logic
	local lReturn			as logic
	
	if _oCanExecute == null
		lReturn				:= true
	else
		lReturn				:= _oCanExecute( oParameter )
	endif
	
	return lReturn
		
public event CanExecuteChanged as EventHandler
	add
		CommandManager.RequerySuggested += VALUE
	end add
	remove
		CommandManager.RequerySuggested -= VALUE
	end remove
end event
//        {
//            add { CommandManager.RequerySuggested += value; }
//            remove { CommandManager.RequerySuggested -= value; }
//        }
          
public method Execute( oParameter as object ) as void

	_oExecute( oParameter )
	
	return

#endregion // ICommand Members

END CLASS
